<?php
/**
 * Plugins configuration example.
 *
 * @var array
 */
$plugins = array(
	'cherry-data-importer' => array(
		'name'   => esc_html__( 'Cherry Data Importer', 'monstroid2' ),
		'source' => 'remote', // 'local', 'remote', 'wordpress' (default).
		'path'   => 'https://github.com/CherryFramework/cherry-data-importer/archive/master.zip',
		'access' => 'base',
	),
	'cherry-ld-mods-switcher' => array(
		'name'   => esc_html__( 'Cherry Live Demo Mods Switcher', 'monstroid2' ),
		'source' => 'local',
		'path'   => MONSTROID2_THEME_DIR . '/assets/includes/plugins/cherry-ld-mods-switcher.zip',
		'access' => 'base',
	),
	'cherry-projects' => array(
		'name'   => esc_html__( 'Cherry Projects', 'monstroid2' ),
		'access' => 'skins',
	),
	'cherry-team-members' => array(
		'name'   => esc_html__( 'Cherry Team Members', 'monstroid2' ),
		'access' => 'skins',
	),
	'cherry-testi' => array(
		'name'   => esc_html__( 'Cherry Testimonials', 'monstroid2' ),
		'access' => 'skins',
	),
	'cherry-services-list' => array(
		'name'   => esc_html__( 'Cherry Services List', 'monstroid2' ),
		'access' => 'skins',
	),
	'cherry-sidebars' => array(
		'name'   => esc_html__( 'Cherry Sidebars', 'monstroid2' ),
		'access' => 'skins',
	),
	'cherry-socialize' => array(
		'name'   => esc_html__( 'Cherry Socialize', 'monstroid2' ),
		'access' => 'skins',
	),
	'cherry-search' => array(
		'name'   => esc_html__( 'Cherry Search', 'monstroid2' ),
		'access' => 'skins',
	),
	'cherry-trending-posts' => array(
		'name'   => esc_html__( 'Cherry Trending Posts', 'monstroid2' ),
		'access' => 'skins',
	),
	'power-builder' => array(
		'name'   => esc_html__( 'Power Builder', 'monstroid2' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/power-builder-upd.zip',
		'access' => 'skins',
	),
	'power-builder-integrator' => array(
		'name'   => esc_html__( 'Power Builder Integrator', 'monstroid2' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/power-builder-integrator.zip',
		'access' => 'skins',
	),
	'tm-mega-menu' => array(
		'name'   => esc_html__( 'TM Mega Menu', 'monstroid2' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/tm-mega-menu.zip',
		'access' => 'skins',
	),
	'tm-style-switcher' => array(
		'name'   => esc_html__( 'TM Style Switcher', 'monstroid2' ),
		'access' => 'skins',
	),
	'tm-photo-gallery' => array(
		'name'   => esc_html__( 'TM Photo Gallery', 'monstroid2' ),
		'access' => 'skins',
	),
	'tm-timeline' => array(
		'name'   => esc_html__( 'TM Timeline', 'monstroid2' ),
		'access' => 'skins',
	),
	'bbpress' => array(
		'name'   => esc_html__( 'bbPress', 'monstroid2' ),
		'access' => 'skins',
	),
	'buddypress' => array(
		'name'   => esc_html__( 'BuddyPress', 'monstroid2' ),
		'access' => 'skins',
	),
	'booked' => array(
		'name'   => esc_html__( 'Booked Appointments', 'monstroid2' ),
		'source' => 'local',
		'path'   => MONSTROID2_THEME_DIR . '/assets/includes/plugins/booked.zip',
		'access' => 'skins',
	),
	'contact-form-7' => array(
		'name'   => esc_html__( 'Contact Form 7', 'monstroid2' ),
		'access' => 'skins',
	),
	'hotel-booking' => array(
		'name'   => esc_html__( 'Hotel Booking by MotoPress', 'monstroid2' ),
		'source' => 'local',
		'path'   => MONSTROID2_THEME_DIR . '/assets/includes/plugins/hotel-booking.zip',
		'access' => 'skins',
	),
	'moto-tools-integration' => array(
		'name'   => esc_html__( 'Moto Tools Integration', 'monstroid2' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/moto-tools-integration.zip',
		'access' => 'skins',
	),
	'mp-restaurant-menu' => array(
		'name'   => esc_html__( 'Restaurant Menu by MotoPress', 'monstroid2' ),
		'access' => 'skins',
	),
	'the-events-calendar' => array(
		'name'   => esc_html__( 'The Events Calendar', 'monstroid2' ),
		'access' => 'skins',
	),
	'mp-timetable' => array(
		'name'   => esc_html__( 'Timetable and Event Schedule', 'monstroid2' ),
		'access' => 'skins',
	),
	'woocommerce' => array(
		'name'   => esc_html__( 'Woocommerce', 'monstroid2' ),
		'access' => 'skins',
	),
	'tm-woocommerce-ajax-filters' => array(
		'name'   => esc_html__( 'TM Woocommerce Ajax Filters', 'monstroid2' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/tm-woocommerce-ajax-filters.zip',
		'access' => 'skins',
	),
	'tm-woocommerce-compare-wishlist' => array(
		'name'   => esc_html__( 'TM Woocommerce Compare Wishlist', 'monstroid2' ),
		'access' => 'skins',
	),
	'tm-woocommerce-package' => array(
		'name'   => esc_html__( 'TM Woocommerce Package', 'monstroid2' ),
		'access' => 'skins',
	),
	'woocommerce-social-media-share-buttons' => array(
		'name'   => esc_html__( 'Woocommerce Social Media Share Buttons', 'monstroid2' ),
		'access' => 'skins',
	),
	'tm-dashboard' => array(
		'name'   => esc_html__( 'TM Dashboard', 'monstroid2' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/tm-dashboard.zip',
		'access' => 'base',
	),
);

/**
 * Skins configuration example
 *
 * @var array
 */
$skins = array(
	'base' => array(
		'cherry-data-importer',
		'cherry-ld-mods-switcher',
		'tm-dashboard',
	),
	'advanced' => array(
		'default' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-mega-menu',
				'tm-style-switcher',
				'tm-timeline',
				'bbpress',
				'buddypress',
				'booked',
				'mp-restaurant-menu',
				'the-events-calendar',
				'mp-timetable',
				'woocommerce',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce-social-media-share-buttons',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-timeline',
				'booked',
				'tm-mega-menu',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_default/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/default/default-thumb.png',
			'name'  => esc_html__( 'Default', 'monstroid2' ),
		),
		'skin-1' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_construction/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-1/skin-1-thumb.png',
			'name'  => esc_html__( 'Construction', 'monstroid2' ),
		),
		'skin-2' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'contact-form-7',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'contact-form-7',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_fashion/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-2/skin-2-thumb.png',
			'name'  => esc_html__( 'Fashion', 'monstroid2' ),
		),
		'skin-3' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'booked',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'booked',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_corporate/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-3/skin-3-thumb.png',
			'name'  => esc_html__( 'Corporate', 'monstroid2' ),
		),
		'skin-4' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
				'woocommerce',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce-social-media-share-buttons',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
				'woocommerce',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-compare-wishlist',
				'tm-woocommerce-package',
				'woocommerce-social-media-share-buttons',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_furni/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-4/skin-4-thumb.png',
			'name'  => esc_html__( 'Furni', 'monstroid2' ),
		),
		'skin-5' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'moto-tools-integration',
				'the-events-calendar',
				'mp-timetable',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'moto-tools-integration',
				'the-events-calendar',
				'mp-timetable',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_ironmass_v1/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-5/skin-5-thumb.png',
			'name'  => esc_html__( 'Ironmass', 'monstroid2' ),
		),
		'skin-6' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'booked',
				'contact-form-7',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'booked',
				'contact-form-7',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_lawyer_v1/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-6/skin-6-thumb.png',
			'name'  => esc_html__( 'Lawyer', 'monstroid2' ),
		),
		'skin-7' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'mp-restaurant-menu',
				'hotel-booking',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'mp-restaurant-menu',
				'hotel-booking',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_modern/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-7/skin-7-thumb.png',
			'name'  => esc_html__( 'Modern', 'monstroid2' ),
		),
		'skin-8' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_loan_v1/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-8/skin-8-thumb.png',
			'name'  => esc_html__( 'Loan', 'monstroid2' ),
		),
		'skin-9' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'booked',
				'mp-restaurant-menu',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'booked',
				'mp-restaurant-menu',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_resto/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-9/skin-9-thumb.png',
			'name'  => esc_html__( 'Resto', 'monstroid2' ),
		),
		'skin-10' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_weelko/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-10/skin-10-thumb.png',
			'name'  => esc_html__( 'Weelko', 'monstroid2' ),
		),
		'skin-11' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_intrabrand/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-11/skin-11-thumb.png',
			'name'  => esc_html__( 'IntraBrand', 'monstroid2' ),
		),
		'skin-12' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'moto-tools-integration',
				'the-events-calendar',
				'mp-timetable',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'moto-tools-integration',
				'the-events-calendar',
				'mp-timetable',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_lingua/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-12/skin-12-thumb.png',
			'name'  => esc_html__( 'Lingua', 'monstroid2' ),
		),
		'skin-13' => array(
			'full'  => array(
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'tm-photo-gallery',
				'power-builder',
				'tm-style-switcher',
				'contact-form-7',
			),
			'lite'  => array(
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'tm-photo-gallery',
				'power-builder',
				'tm-style-switcher',
				'contact-form-7',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_mariejuliette/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-13/skin-13-thumb.png',
			'name'  => esc_html__( 'MarieJuliette', 'monstroid2' ),
		),
		'skin-14' => array(
			'full'  => array(
				'cherry-trending-posts',
				'tm-style-switcher',
				'contact-form-7',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
			),
			'lite'  => array(
				'cherry-trending-posts',
				'tm-style-switcher',
				'contact-form-7',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_ollnew/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-14/skin-14-thumb.png',
			'name'  => esc_html__( 'Ollnew', 'monstroid2' ),
		),
		'skin-15' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-services-list',
				'cherry-socialize',
				'cherry-sidebars',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'contact-form-7',
				'tm-style-switcher',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-search',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'contact-form-7',
				'tm-style-switcher',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_showpage/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-15/skin-15-thumb.png',
			'name'  => esc_html__( 'ShowPage', 'monstroid2' ),
		),
		'skin-16' => array(
			'full'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
				'tm-mega-menu',
			),
			'lite'  => array(
				'cherry-projects',
				'cherry-team-members',
				'cherry-testi',
				'cherry-services-list',
				'cherry-sidebars',
				'cherry-socialize',
				'cherry-trending-posts',
				'power-builder',
				'power-builder-integrator',
				'tm-style-switcher',
				'tm-mega-menu',
			),
			'demo'  => 'https://ld-wp.template-help.com/wordpress_62222_reflax/',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/skin-16/skin-16-thumb.png',
			'name'  => esc_html__( 'Reflax', 'monstroid2' ),
		),
	),
);
